package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  NextToken,
  ListFindingAggregationsMaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFindingAggregationsRequest(
    accountIds: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    aggregationRequest: Optional[zio.aws.inspector2.model.AggregationRequest] =
      Optional.Absent,
    aggregationType: zio.aws.inspector2.model.AggregationType,
    maxResults: Optional[ListFindingAggregationsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest = {
    import ListFindingAggregationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(aggregationRequest.map(value => value.buildAwsValue()))(
        _.aggregationRequest
      )
      .aggregationType(aggregationType.unwrap)
      .optionallyWith(
        maxResults.map(value =>
          ListFindingAggregationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListFindingAggregationsRequest.ReadOnly =
    zio.aws.inspector2.model.ListFindingAggregationsRequest
      .wrap(buildAwsValue())
}
object ListFindingAggregationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListFindingAggregationsRequest =
      zio.aws.inspector2.model.ListFindingAggregationsRequest(
        accountIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aggregationRequest.map(value => value.asEditable),
        aggregationType,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def aggregationRequest
        : Optional[zio.aws.inspector2.model.AggregationRequest.ReadOnly]
    def aggregationType: zio.aws.inspector2.model.AggregationType
    def maxResults: Optional[ListFindingAggregationsMaxResults]
    def nextToken: Optional[NextToken]
    def getAccountIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("accountIds", accountIds)
    def getAggregationRequest: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AggregationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("aggregationRequest", aggregationRequest)
    def getAggregationType
        : ZIO[Any, Nothing, zio.aws.inspector2.model.AggregationType] =
      ZIO.succeed(aggregationType)
    def getMaxResults: ZIO[Any, AwsError, ListFindingAggregationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest
  ) extends zio.aws.inspector2.model.ListFindingAggregationsRequest.ReadOnly {
    override val accountIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val aggregationRequest
        : Optional[zio.aws.inspector2.model.AggregationRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationRequest())
        .map(value => zio.aws.inspector2.model.AggregationRequest.wrap(value))
    override val aggregationType: zio.aws.inspector2.model.AggregationType =
      zio.aws.inspector2.model.AggregationType.wrap(impl.aggregationType())
    override val maxResults: Optional[ListFindingAggregationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives
            .ListFindingAggregationsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest
  ): zio.aws.inspector2.model.ListFindingAggregationsRequest.ReadOnly =
    new Wrapper(impl)
}
