package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters._
final case class FailedAccount(
    accountId: AccountId,
    errorCode: zio.aws.inspector2.model.ErrorCode,
    errorMessage: NonEmptyString,
    resourceStatus: Optional[zio.aws.inspector2.model.ResourceStatus] =
      Optional.Absent,
    status: Optional[zio.aws.inspector2.model.Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FailedAccount = {
    import FailedAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FailedAccount
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .errorCode(errorCode.unwrap)
      .errorMessage(NonEmptyString.unwrap(errorMessage): java.lang.String)
      .optionallyWith(resourceStatus.map(value => value.buildAwsValue()))(
        _.resourceStatus
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FailedAccount.ReadOnly =
    zio.aws.inspector2.model.FailedAccount.wrap(buildAwsValue())
}
object FailedAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FailedAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FailedAccount =
      zio.aws.inspector2.model.FailedAccount(
        accountId,
        errorCode,
        errorMessage,
        resourceStatus.map(value => value.asEditable),
        status.map(value => value)
      )
    def accountId: AccountId
    def errorCode: zio.aws.inspector2.model.ErrorCode
    def errorMessage: NonEmptyString
    def resourceStatus
        : Optional[zio.aws.inspector2.model.ResourceStatus.ReadOnly]
    def status: Optional[zio.aws.inspector2.model.Status]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getErrorCode: ZIO[Any, Nothing, zio.aws.inspector2.model.ErrorCode] =
      ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(errorMessage)
    def getResourceStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ResourceStatus.ReadOnly] =
      AwsError.unwrapOptionField("resourceStatus", resourceStatus)
    def getStatus: ZIO[Any, AwsError, zio.aws.inspector2.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FailedAccount
  ) extends zio.aws.inspector2.model.FailedAccount.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val errorCode: zio.aws.inspector2.model.ErrorCode =
      zio.aws.inspector2.model.ErrorCode.wrap(impl.errorCode())
    override val errorMessage: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.errorMessage())
    override val resourceStatus
        : Optional[zio.aws.inspector2.model.ResourceStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceStatus())
        .map(value => zio.aws.inspector2.model.ResourceStatus.wrap(value))
    override val status: Optional[zio.aws.inspector2.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.inspector2.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FailedAccount
  ): zio.aws.inspector2.model.FailedAccount.ReadOnly = new Wrapper(impl)
}
