package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceScanMetadata(
    ec2: Option[zio.aws.inspector2.model.Ec2Metadata] = None,
    ecrImage: Option[zio.aws.inspector2.model.EcrContainerImageMetadata] = None,
    ecrRepository: Option[zio.aws.inspector2.model.EcrRepositoryMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata = {
    import ResourceScanMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata
      .builder()
      .optionallyWith(ec2.map(value => value.buildAwsValue()))(_.ec2)
      .optionallyWith(ecrImage.map(value => value.buildAwsValue()))(_.ecrImage)
      .optionallyWith(ecrRepository.map(value => value.buildAwsValue()))(
        _.ecrRepository
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly =
    zio.aws.inspector2.model.ResourceScanMetadata.wrap(buildAwsValue())
}
object ResourceScanMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceScanMetadata =
      zio.aws.inspector2.model.ResourceScanMetadata(
        ec2.map(value => value.asEditable),
        ecrImage.map(value => value.asEditable),
        ecrRepository.map(value => value.asEditable)
      )
    def ec2: Option[zio.aws.inspector2.model.Ec2Metadata.ReadOnly]
    def ecrImage
        : Option[zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly]
    def ecrRepository
        : Option[zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly]
    def getEc2
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Ec2Metadata.ReadOnly] =
      AwsError.unwrapOptionField("ec2", ec2)
    def getEcrImage: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("ecrImage", ecrImage)
    def getEcrRepository: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("ecrRepository", ecrRepository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata
  ) extends zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly {
    override val ec2: Option[zio.aws.inspector2.model.Ec2Metadata.ReadOnly] =
      scala
        .Option(impl.ec2())
        .map(value => zio.aws.inspector2.model.Ec2Metadata.wrap(value))
    override val ecrImage
        : Option[zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly] =
      scala
        .Option(impl.ecrImage())
        .map(value =>
          zio.aws.inspector2.model.EcrContainerImageMetadata.wrap(value)
        )
    override val ecrRepository
        : Option[zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly] =
      scala
        .Option(impl.ecrRepository())
        .map(value =>
          zio.aws.inspector2.model.EcrRepositoryMetadata.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata
  ): zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly = new Wrapper(impl)
}
