package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.AggCounts
import scala.jdk.CollectionConverters._
final case class Counts(
    count: Option[AggCounts] = None,
    groupKey: Option[zio.aws.inspector2.model.GroupKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Counts = {
    import Counts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Counts
      .builder()
      .optionallyWith(
        count.map(value => AggCounts.unwrap(value): java.lang.Long)
      )(_.count)
      .optionallyWith(groupKey.map(value => value.unwrap))(_.groupKey)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Counts.ReadOnly =
    zio.aws.inspector2.model.Counts.wrap(buildAwsValue())
}
object Counts {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Counts] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Counts = zio.aws.inspector2.model
      .Counts(count.map(value => value), groupKey.map(value => value))
    def count: Option[AggCounts]
    def groupKey: Option[zio.aws.inspector2.model.GroupKey]
    def getCount: ZIO[Any, AwsError, AggCounts] =
      AwsError.unwrapOptionField("count", count)
    def getGroupKey: ZIO[Any, AwsError, zio.aws.inspector2.model.GroupKey] =
      AwsError.unwrapOptionField("groupKey", groupKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Counts
  ) extends zio.aws.inspector2.model.Counts.ReadOnly {
    override val count: Option[AggCounts] = scala
      .Option(impl.count())
      .map(value => zio.aws.inspector2.model.primitives.AggCounts(value))
    override val groupKey: Option[zio.aws.inspector2.model.GroupKey] = scala
      .Option(impl.groupKey())
      .map(value => zio.aws.inspector2.model.GroupKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Counts
  ): zio.aws.inspector2.model.Counts.ReadOnly = new Wrapper(impl)
}
