package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters._
final case class TitleAggregationResponse(
    accountId: Option[AccountId] = None,
    severityCounts: Option[zio.aws.inspector2.model.SeverityCounts] = None,
    title: NonEmptyString,
    vulnerabilityId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse = {
    import TitleAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .title(NonEmptyString.unwrap(title): java.lang.String)
      .optionallyWith(vulnerabilityId.map(value => value: java.lang.String))(
        _.vulnerabilityId
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.TitleAggregationResponse.wrap(buildAwsValue())
}
object TitleAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.TitleAggregationResponse =
      zio.aws.inspector2.model.TitleAggregationResponse(
        accountId.map(value => value),
        severityCounts.map(value => value.asEditable),
        title,
        vulnerabilityId.map(value => value)
      )
    def accountId: Option[AccountId]
    def severityCounts: Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def title: NonEmptyString
    def vulnerabilityId: Option[String]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
    def getTitle: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(title)
    def getVulnerabilityId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vulnerabilityId", vulnerabilityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse
  ) extends zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val severityCounts
        : Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly] = scala
      .Option(impl.severityCounts())
      .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
    override val title: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.title())
    override val vulnerabilityId: Option[String] =
      scala.Option(impl.vulnerabilityId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse
  ): zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly = new Wrapper(
    impl
  )
}
