package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FilterCriteria(
    awsAccountId: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    componentId: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    componentType: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    ec2InstanceImageId: Option[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = None,
    ec2InstanceSubnetId: Option[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = None,
    ec2InstanceVpcId: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    ecrImageArchitecture: Option[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = None,
    ecrImageHash: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    ecrImagePushedAt: Option[Iterable[zio.aws.inspector2.model.DateFilter]] =
      None,
    ecrImageRegistry: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    ecrImageRepositoryName: Option[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = None,
    ecrImageTags: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    findingArn: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    findingStatus: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    findingType: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    firstObservedAt: Option[Iterable[zio.aws.inspector2.model.DateFilter]] =
      None,
    inspectorScore: Option[Iterable[zio.aws.inspector2.model.NumberFilter]] =
      None,
    lastObservedAt: Option[Iterable[zio.aws.inspector2.model.DateFilter]] =
      None,
    networkProtocol: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    portRange: Option[Iterable[zio.aws.inspector2.model.PortRangeFilter]] =
      None,
    relatedVulnerabilities: Option[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = None,
    resourceId: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    resourceTags: Option[Iterable[zio.aws.inspector2.model.MapFilter]] = None,
    resourceType: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    severity: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    title: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    updatedAt: Option[Iterable[zio.aws.inspector2.model.DateFilter]] = None,
    vendorSeverity: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    vulnerabilityId: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    vulnerabilitySource: Option[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = None,
    vulnerablePackages: Option[
      Iterable[zio.aws.inspector2.model.PackageFilter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FilterCriteria = {
    import FilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FilterCriteria
      .builder()
      .optionallyWith(
        awsAccountId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsAccountId)
      .optionallyWith(
        componentId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.componentId)
      .optionallyWith(
        componentType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.componentType)
      .optionallyWith(
        ec2InstanceImageId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceImageId)
      .optionallyWith(
        ec2InstanceSubnetId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceSubnetId)
      .optionallyWith(
        ec2InstanceVpcId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceVpcId)
      .optionallyWith(
        ecrImageArchitecture.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageArchitecture)
      .optionallyWith(
        ecrImageHash.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageHash)
      .optionallyWith(
        ecrImagePushedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImagePushedAt)
      .optionallyWith(
        ecrImageRegistry.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageRegistry)
      .optionallyWith(
        ecrImageRepositoryName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageRepositoryName)
      .optionallyWith(
        ecrImageTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageTags)
      .optionallyWith(
        findingArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingArn)
      .optionallyWith(
        findingStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingStatus)
      .optionallyWith(
        findingType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingType)
      .optionallyWith(
        firstObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firstObservedAt)
      .optionallyWith(
        inspectorScore.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inspectorScore)
      .optionallyWith(
        lastObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastObservedAt)
      .optionallyWith(
        networkProtocol.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkProtocol)
      .optionallyWith(
        portRange.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRange)
      .optionallyWith(
        relatedVulnerabilities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedVulnerabilities)
      .optionallyWith(
        resourceId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceId)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(
        resourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceType)
      .optionallyWith(
        severity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severity)
      .optionallyWith(
        title.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.title)
      .optionallyWith(
        updatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updatedAt)
      .optionallyWith(
        vendorSeverity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vendorSeverity)
      .optionallyWith(
        vulnerabilityId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerabilityId)
      .optionallyWith(
        vulnerabilitySource.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerabilitySource)
      .optionallyWith(
        vulnerablePackages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerablePackages)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FilterCriteria.ReadOnly =
    zio.aws.inspector2.model.FilterCriteria.wrap(buildAwsValue())
}
object FilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FilterCriteria =
      zio.aws.inspector2.model.FilterCriteria(
        awsAccountId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        componentId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        componentType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceImageId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceSubnetId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceVpcId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageArchitecture.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageHash.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImagePushedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageRegistry.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageRepositoryName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firstObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inspectorScore.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkProtocol.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        portRange.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedVulnerabilities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severity.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        title.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vendorSeverity.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vulnerabilityId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vulnerabilitySource.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vulnerablePackages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsAccountId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def componentId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def componentType
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ec2InstanceImageId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ec2InstanceSubnetId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ec2InstanceVpcId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImageArchitecture
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImageHash
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImagePushedAt
        : Option[List[zio.aws.inspector2.model.DateFilter.ReadOnly]]
    def ecrImageRegistry
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImageRepositoryName
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImageTags
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def findingArn: Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def findingStatus
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def findingType
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def firstObservedAt
        : Option[List[zio.aws.inspector2.model.DateFilter.ReadOnly]]
    def inspectorScore
        : Option[List[zio.aws.inspector2.model.NumberFilter.ReadOnly]]
    def lastObservedAt
        : Option[List[zio.aws.inspector2.model.DateFilter.ReadOnly]]
    def networkProtocol
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def portRange
        : Option[List[zio.aws.inspector2.model.PortRangeFilter.ReadOnly]]
    def relatedVulnerabilities
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def resourceId: Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def resourceTags: Option[List[zio.aws.inspector2.model.MapFilter.ReadOnly]]
    def resourceType
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def severity: Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def title: Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def updatedAt: Option[List[zio.aws.inspector2.model.DateFilter.ReadOnly]]
    def vendorSeverity
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def vulnerabilityId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def vulnerabilitySource
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def vulnerablePackages
        : Option[List[zio.aws.inspector2.model.PackageFilter.ReadOnly]]
    def getAwsAccountId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getComponentId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("componentId", componentId)
    def getComponentType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("componentType", componentType)
    def getEc2InstanceImageId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceImageId", ec2InstanceImageId)
    def getEc2InstanceSubnetId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceSubnetId", ec2InstanceSubnetId)
    def getEc2InstanceVpcId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceVpcId", ec2InstanceVpcId)
    def getEcrImageArchitecture: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("ecrImageArchitecture", ecrImageArchitecture)
    def getEcrImageHash: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageHash", ecrImageHash)
    def getEcrImagePushedAt: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImagePushedAt", ecrImagePushedAt)
    def getEcrImageRegistry: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageRegistry", ecrImageRegistry)
    def getEcrImageRepositoryName: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ecrImageRepositoryName",
      ecrImageRepositoryName
    )
    def getEcrImageTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageTags", ecrImageTags)
    def getFindingArn: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("findingArn", findingArn)
    def getFindingStatus: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("findingStatus", findingStatus)
    def getFindingType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("findingType", findingType)
    def getFirstObservedAt: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("firstObservedAt", firstObservedAt)
    def getInspectorScore: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("inspectorScore", inspectorScore)
    def getLastObservedAt: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("lastObservedAt", lastObservedAt)
    def getNetworkProtocol: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkProtocol", networkProtocol)
    def getPortRange: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.PortRangeFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("portRange", portRange)
    def getRelatedVulnerabilities: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relatedVulnerabilities",
      relatedVulnerabilities
    )
    def getResourceId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getResourceType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getSeverity: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severity", severity)
    def getTitle: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("title", title)
    def getUpdatedAt: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getVendorSeverity: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vendorSeverity", vendorSeverity)
    def getVulnerabilityId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerabilityId", vulnerabilityId)
    def getVulnerabilitySource: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerabilitySource", vulnerabilitySource)
    def getVulnerablePackages: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.PackageFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerablePackages", vulnerablePackages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FilterCriteria
  ) extends zio.aws.inspector2.model.FilterCriteria.ReadOnly {
    override val awsAccountId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.awsAccountId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val componentId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.componentId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val componentType
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.componentType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val ec2InstanceImageId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.ec2InstanceImageId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val ec2InstanceSubnetId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.ec2InstanceSubnetId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val ec2InstanceVpcId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.ec2InstanceVpcId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val ecrImageArchitecture
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.ecrImageArchitecture())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val ecrImageHash
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.ecrImageHash())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val ecrImagePushedAt
        : Option[List[zio.aws.inspector2.model.DateFilter.ReadOnly]] = scala
      .Option(impl.ecrImagePushedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.DateFilter.wrap(item)
        }.toList
      )
    override val ecrImageRegistry
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.ecrImageRegistry())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val ecrImageRepositoryName
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.ecrImageRepositoryName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val ecrImageTags
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.ecrImageTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val findingArn
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.findingArn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val findingStatus
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.findingStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val findingType
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.findingType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val firstObservedAt
        : Option[List[zio.aws.inspector2.model.DateFilter.ReadOnly]] = scala
      .Option(impl.firstObservedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.DateFilter.wrap(item)
        }.toList
      )
    override val inspectorScore
        : Option[List[zio.aws.inspector2.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.inspectorScore())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.NumberFilter.wrap(item)
        }.toList
      )
    override val lastObservedAt
        : Option[List[zio.aws.inspector2.model.DateFilter.ReadOnly]] = scala
      .Option(impl.lastObservedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.DateFilter.wrap(item)
        }.toList
      )
    override val networkProtocol
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.networkProtocol())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val portRange
        : Option[List[zio.aws.inspector2.model.PortRangeFilter.ReadOnly]] =
      scala
        .Option(impl.portRange())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.PortRangeFilter.wrap(item)
          }.toList
        )
    override val relatedVulnerabilities
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.relatedVulnerabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceTags
        : Option[List[zio.aws.inspector2.model.MapFilter.ReadOnly]] = scala
      .Option(impl.resourceTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.MapFilter.wrap(item)
        }.toList
      )
    override val resourceType
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val severity
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.severity())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val title
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.title())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val updatedAt
        : Option[List[zio.aws.inspector2.model.DateFilter.ReadOnly]] = scala
      .Option(impl.updatedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.DateFilter.wrap(item)
        }.toList
      )
    override val vendorSeverity
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.vendorSeverity())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val vulnerabilityId
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.vulnerabilityId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val vulnerabilitySource
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.vulnerabilitySource())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val vulnerablePackages
        : Option[List[zio.aws.inspector2.model.PackageFilter.ReadOnly]] = scala
      .Option(impl.vulnerablePackages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.PackageFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FilterCriteria
  ): zio.aws.inspector2.model.FilterCriteria.ReadOnly = new Wrapper(impl)
}
