package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class AccountState(
    accountId: AccountId,
    resourceState: zio.aws.inspector2.model.ResourceState,
    state: zio.aws.inspector2.model.State
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AccountState = {
    import AccountState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AccountState
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .resourceState(resourceState.buildAwsValue())
      .state(state.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AccountState.ReadOnly =
    zio.aws.inspector2.model.AccountState.wrap(buildAwsValue())
}
object AccountState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AccountState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AccountState =
      zio.aws.inspector2.model
        .AccountState(accountId, resourceState.asEditable, state.asEditable)
    def accountId: AccountId
    def resourceState: zio.aws.inspector2.model.ResourceState.ReadOnly
    def state: zio.aws.inspector2.model.State.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getResourceState
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ResourceState.ReadOnly] =
      ZIO.succeed(resourceState)
    def getState: ZIO[Any, Nothing, zio.aws.inspector2.model.State.ReadOnly] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AccountState
  ) extends zio.aws.inspector2.model.AccountState.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val resourceState
        : zio.aws.inspector2.model.ResourceState.ReadOnly =
      zio.aws.inspector2.model.ResourceState.wrap(impl.resourceState())
    override val state: zio.aws.inspector2.model.State.ReadOnly =
      zio.aws.inspector2.model.State.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AccountState
  ): zio.aws.inspector2.model.AccountState.ReadOnly = new Wrapper(impl)
}
