package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CoverageFilterCriteria(
    accountId: Option[Iterable[zio.aws.inspector2.model.CoverageStringFilter]] =
      None,
    ec2InstanceTags: Option[
      Iterable[zio.aws.inspector2.model.CoverageMapFilter]
    ] = None,
    ecrImageTags: Option[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = None,
    ecrRepositoryName: Option[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = None,
    resourceId: Option[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = None,
    resourceType: Option[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = None,
    scanStatusCode: Option[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = None,
    scanStatusReason: Option[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = None,
    scanType: Option[Iterable[zio.aws.inspector2.model.CoverageStringFilter]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria = {
    import CoverageFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria
      .builder()
      .optionallyWith(
        accountId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountId)
      .optionallyWith(
        ec2InstanceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceTags)
      .optionallyWith(
        ecrImageTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageTags)
      .optionallyWith(
        ecrRepositoryName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrRepositoryName)
      .optionallyWith(
        resourceId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceId)
      .optionallyWith(
        resourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceType)
      .optionallyWith(
        scanStatusCode.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanStatusCode)
      .optionallyWith(
        scanStatusReason.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanStatusReason)
      .optionallyWith(
        scanType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanType)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.CoverageFilterCriteria.wrap(buildAwsValue())
}
object CoverageFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CoverageFilterCriteria =
      zio.aws.inspector2.model.CoverageFilterCriteria(
        accountId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrRepositoryName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanStatusCode.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanStatusReason.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanType.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountId
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def ec2InstanceTags
        : Option[List[zio.aws.inspector2.model.CoverageMapFilter.ReadOnly]]
    def ecrImageTags
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def ecrRepositoryName
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def resourceId
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def resourceType
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def scanStatusCode
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def scanStatusReason
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def scanType
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def getAccountId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("accountId", accountId)
    def getEc2InstanceTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageMapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceTags", ec2InstanceTags)
    def getEcrImageTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageTags", ecrImageTags)
    def getEcrRepositoryName: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrRepositoryName", ecrRepositoryName)
    def getResourceId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getScanStatusCode: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanStatusCode", scanStatusCode)
    def getScanStatusReason: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanStatusReason", scanStatusReason)
    def getScanType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanType", scanType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria
  ) extends zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly {
    override val accountId
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]] =
      scala
        .Option(impl.accountId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
          }.toList
        )
    override val ec2InstanceTags
        : Option[List[zio.aws.inspector2.model.CoverageMapFilter.ReadOnly]] =
      scala
        .Option(impl.ec2InstanceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageMapFilter.wrap(item)
          }.toList
        )
    override val ecrImageTags
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]] =
      scala
        .Option(impl.ecrImageTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
          }.toList
        )
    override val ecrRepositoryName
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]] =
      scala
        .Option(impl.ecrRepositoryName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
          }.toList
        )
    override val resourceId
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]] =
      scala
        .Option(impl.resourceId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
          }.toList
        )
    override val resourceType
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
          }.toList
        )
    override val scanStatusCode
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]] =
      scala
        .Option(impl.scanStatusCode())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
          }.toList
        )
    override val scanStatusReason
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]] =
      scala
        .Option(impl.scanStatusReason())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
          }.toList
        )
    override val scanType
        : Option[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]] =
      scala
        .Option(impl.scanType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria
  ): zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly = new Wrapper(
    impl
  )
}
