package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.StringInput
import scala.jdk.CollectionConverters._
final case class StringFilter(
    comparison: zio.aws.inspector2.model.StringComparison,
    value: StringInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.StringFilter = {
    import StringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.StringFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(StringInput.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.StringFilter.ReadOnly =
    zio.aws.inspector2.model.StringFilter.wrap(buildAwsValue())
}
object StringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.StringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.StringFilter =
      zio.aws.inspector2.model.StringFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.StringComparison
    def value: StringInput
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.StringComparison] =
      ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, StringInput] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.StringFilter
  ) extends zio.aws.inspector2.model.StringFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.StringComparison =
      zio.aws.inspector2.model.StringComparison.wrap(impl.comparison())
    override val value: StringInput =
      zio.aws.inspector2.model.primitives.StringInput(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.StringFilter
  ): zio.aws.inspector2.model.StringFilter.ReadOnly = new Wrapper(impl)
}
