package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AggregationResponse(
    accountAggregation: Option[
      zio.aws.inspector2.model.AccountAggregationResponse
    ] = None,
    amiAggregation: Option[zio.aws.inspector2.model.AmiAggregationResponse] =
      None,
    awsEcrContainerAggregation: Option[
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse
    ] = None,
    ec2InstanceAggregation: Option[
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse
    ] = None,
    findingTypeAggregation: Option[
      zio.aws.inspector2.model.FindingTypeAggregationResponse
    ] = None,
    imageLayerAggregation: Option[
      zio.aws.inspector2.model.ImageLayerAggregationResponse
    ] = None,
    packageAggregation: Option[
      zio.aws.inspector2.model.PackageAggregationResponse
    ] = None,
    repositoryAggregation: Option[
      zio.aws.inspector2.model.RepositoryAggregationResponse
    ] = None,
    titleAggregation: Option[
      zio.aws.inspector2.model.TitleAggregationResponse
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AggregationResponse = {
    import AggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AggregationResponse
      .builder()
      .optionallyWith(accountAggregation.map(value => value.buildAwsValue()))(
        _.accountAggregation
      )
      .optionallyWith(amiAggregation.map(value => value.buildAwsValue()))(
        _.amiAggregation
      )
      .optionallyWith(
        awsEcrContainerAggregation.map(value => value.buildAwsValue())
      )(_.awsEcrContainerAggregation)
      .optionallyWith(
        ec2InstanceAggregation.map(value => value.buildAwsValue())
      )(_.ec2InstanceAggregation)
      .optionallyWith(
        findingTypeAggregation.map(value => value.buildAwsValue())
      )(_.findingTypeAggregation)
      .optionallyWith(
        imageLayerAggregation.map(value => value.buildAwsValue())
      )(_.imageLayerAggregation)
      .optionallyWith(packageAggregation.map(value => value.buildAwsValue()))(
        _.packageAggregation
      )
      .optionallyWith(
        repositoryAggregation.map(value => value.buildAwsValue())
      )(_.repositoryAggregation)
      .optionallyWith(titleAggregation.map(value => value.buildAwsValue()))(
        _.titleAggregation
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AggregationResponse.ReadOnly =
    zio.aws.inspector2.model.AggregationResponse.wrap(buildAwsValue())
}
object AggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AggregationResponse =
      zio.aws.inspector2.model.AggregationResponse(
        accountAggregation.map(value => value.asEditable),
        amiAggregation.map(value => value.asEditable),
        awsEcrContainerAggregation.map(value => value.asEditable),
        ec2InstanceAggregation.map(value => value.asEditable),
        findingTypeAggregation.map(value => value.asEditable),
        imageLayerAggregation.map(value => value.asEditable),
        packageAggregation.map(value => value.asEditable),
        repositoryAggregation.map(value => value.asEditable),
        titleAggregation.map(value => value.asEditable)
      )
    def accountAggregation
        : Option[zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly]
    def amiAggregation
        : Option[zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly]
    def awsEcrContainerAggregation: Option[
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly
    ]
    def ec2InstanceAggregation: Option[
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly
    ]
    def findingTypeAggregation: Option[
      zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly
    ]
    def imageLayerAggregation: Option[
      zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly
    ]
    def packageAggregation
        : Option[zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly]
    def repositoryAggregation: Option[
      zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly
    ]
    def titleAggregation
        : Option[zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly]
    def getAccountAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("accountAggregation", accountAggregation)
    def getAmiAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("amiAggregation", amiAggregation)
    def getAwsEcrContainerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEcrContainerAggregation",
      awsEcrContainerAggregation
    )
    def getEc2InstanceAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2InstanceAggregation",
      ec2InstanceAggregation
    )
    def getFindingTypeAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "findingTypeAggregation",
      findingTypeAggregation
    )
    def getImageLayerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("imageLayerAggregation", imageLayerAggregation)
    def getPackageAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("packageAggregation", packageAggregation)
    def getRepositoryAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("repositoryAggregation", repositoryAggregation)
    def getTitleAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("titleAggregation", titleAggregation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AggregationResponse
  ) extends zio.aws.inspector2.model.AggregationResponse.ReadOnly {
    override val accountAggregation
        : Option[zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly] =
      scala
        .Option(impl.accountAggregation())
        .map(value =>
          zio.aws.inspector2.model.AccountAggregationResponse.wrap(value)
        )
    override val amiAggregation
        : Option[zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly] =
      scala
        .Option(impl.amiAggregation())
        .map(value =>
          zio.aws.inspector2.model.AmiAggregationResponse.wrap(value)
        )
    override val awsEcrContainerAggregation: Option[
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly
    ] = scala
      .Option(impl.awsEcrContainerAggregation())
      .map(value =>
        zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.wrap(value)
      )
    override val ec2InstanceAggregation: Option[
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly
    ] = scala
      .Option(impl.ec2InstanceAggregation())
      .map(value =>
        zio.aws.inspector2.model.Ec2InstanceAggregationResponse.wrap(value)
      )
    override val findingTypeAggregation: Option[
      zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly
    ] = scala
      .Option(impl.findingTypeAggregation())
      .map(value =>
        zio.aws.inspector2.model.FindingTypeAggregationResponse.wrap(value)
      )
    override val imageLayerAggregation: Option[
      zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly
    ] = scala
      .Option(impl.imageLayerAggregation())
      .map(value =>
        zio.aws.inspector2.model.ImageLayerAggregationResponse.wrap(value)
      )
    override val packageAggregation
        : Option[zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly] =
      scala
        .Option(impl.packageAggregation())
        .map(value =>
          zio.aws.inspector2.model.PackageAggregationResponse.wrap(value)
        )
    override val repositoryAggregation: Option[
      zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly
    ] = scala
      .Option(impl.repositoryAggregation())
      .map(value =>
        zio.aws.inspector2.model.RepositoryAggregationResponse.wrap(value)
      )
    override val titleAggregation
        : Option[zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly] =
      scala
        .Option(impl.titleAggregation())
        .map(value =>
          zio.aws.inspector2.model.TitleAggregationResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AggregationResponse
  ): zio.aws.inspector2.model.AggregationResponse.ReadOnly = new Wrapper(impl)
}
