package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{UsageValue, MonthlyCostEstimate}
import scala.jdk.CollectionConverters._
final case class Usage(
    currency: Option[zio.aws.inspector2.model.Currency] = None,
    estimatedMonthlyCost: Option[MonthlyCostEstimate] = None,
    total: Option[UsageValue] = None,
    `type`: Option[zio.aws.inspector2.model.UsageType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Usage = {
    import Usage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Usage
      .builder()
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(
        estimatedMonthlyCost.map(value =>
          MonthlyCostEstimate.unwrap(value): java.lang.Double
        )
      )(_.estimatedMonthlyCost)
      .optionallyWith(
        total.map(value => UsageValue.unwrap(value): java.lang.Double)
      )(_.total)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Usage.ReadOnly =
    zio.aws.inspector2.model.Usage.wrap(buildAwsValue())
}
object Usage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Usage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Usage =
      zio.aws.inspector2.model.Usage(
        currency.map(value => value),
        estimatedMonthlyCost.map(value => value),
        total.map(value => value),
        `type`.map(value => value)
      )
    def currency: Option[zio.aws.inspector2.model.Currency]
    def estimatedMonthlyCost: Option[MonthlyCostEstimate]
    def total: Option[UsageValue]
    def `type`: Option[zio.aws.inspector2.model.UsageType]
    def getCurrency: ZIO[Any, AwsError, zio.aws.inspector2.model.Currency] =
      AwsError.unwrapOptionField("currency", currency)
    def getEstimatedMonthlyCost: ZIO[Any, AwsError, MonthlyCostEstimate] =
      AwsError.unwrapOptionField("estimatedMonthlyCost", estimatedMonthlyCost)
    def getTotal: ZIO[Any, AwsError, UsageValue] =
      AwsError.unwrapOptionField("total", total)
    def getType: ZIO[Any, AwsError, zio.aws.inspector2.model.UsageType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Usage
  ) extends zio.aws.inspector2.model.Usage.ReadOnly {
    override val currency: Option[zio.aws.inspector2.model.Currency] = scala
      .Option(impl.currency())
      .map(value => zio.aws.inspector2.model.Currency.wrap(value))
    override val estimatedMonthlyCost: Option[MonthlyCostEstimate] = scala
      .Option(impl.estimatedMonthlyCost())
      .map(value =>
        zio.aws.inspector2.model.primitives.MonthlyCostEstimate(value)
      )
    override val total: Option[UsageValue] = scala
      .Option(impl.total())
      .map(value => zio.aws.inspector2.model.primitives.UsageValue(value))
    override val `type`: Option[zio.aws.inspector2.model.UsageType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.inspector2.model.UsageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Usage
  ): zio.aws.inspector2.model.Usage.ReadOnly = new Wrapper(impl)
}
