package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait MapComparison {
  def unwrap: software.amazon.awssdk.services.inspector2.model.MapComparison
}
object MapComparison {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.MapComparison
  ): zio.aws.inspector2.model.MapComparison = value match {
    case software.amazon.awssdk.services.inspector2.model.MapComparison.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.MapComparison.EQUALS =>
      val r = EQUALS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.MapComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.MapComparison =
      software.amazon.awssdk.services.inspector2.model.MapComparison.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.inspector2.model.MapComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.MapComparison =
      software.amazon.awssdk.services.inspector2.model.MapComparison.EQUALS
  }
}
