package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListMembersResponse(
    members: Option[Iterable[zio.aws.inspector2.model.Member]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListMembersResponse = {
    import ListMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListMembersResponse.ReadOnly =
    zio.aws.inspector2.model.ListMembersResponse.wrap(buildAwsValue())
}
object ListMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListMembersResponse =
      zio.aws.inspector2.model.ListMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def members: Option[List[zio.aws.inspector2.model.Member.ReadOnly]]
    def nextToken: Option[NextToken]
    def getMembers
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.Member.ReadOnly]] =
      AwsError.unwrapOptionField("members", members)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListMembersResponse
  ) extends zio.aws.inspector2.model.ListMembersResponse.ReadOnly {
    override val members
        : Option[List[zio.aws.inspector2.model.Member.ReadOnly]] = scala
      .Option(impl.members())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.Member.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListMembersResponse
  ): zio.aws.inspector2.model.ListMembersResponse.ReadOnly = new Wrapper(impl)
}
