package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InspectorScoreDetails(
    adjustedCvss: Option[zio.aws.inspector2.model.CvssScoreDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.InspectorScoreDetails = {
    import InspectorScoreDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.InspectorScoreDetails
      .builder()
      .optionallyWith(adjustedCvss.map(value => value.buildAwsValue()))(
        _.adjustedCvss
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.InspectorScoreDetails.ReadOnly =
    zio.aws.inspector2.model.InspectorScoreDetails.wrap(buildAwsValue())
}
object InspectorScoreDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.InspectorScoreDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.InspectorScoreDetails =
      zio.aws.inspector2.model
        .InspectorScoreDetails(adjustedCvss.map(value => value.asEditable))
    def adjustedCvss: Option[zio.aws.inspector2.model.CvssScoreDetails.ReadOnly]
    def getAdjustedCvss: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CvssScoreDetails.ReadOnly
    ] = AwsError.unwrapOptionField("adjustedCvss", adjustedCvss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.InspectorScoreDetails
  ) extends zio.aws.inspector2.model.InspectorScoreDetails.ReadOnly {
    override val adjustedCvss
        : Option[zio.aws.inspector2.model.CvssScoreDetails.ReadOnly] = scala
      .Option(impl.adjustedCvss())
      .map(value => zio.aws.inspector2.model.CvssScoreDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.InspectorScoreDetails
  ): zio.aws.inspector2.model.InspectorScoreDetails.ReadOnly = new Wrapper(impl)
}
