package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait AggregationType {
  def unwrap: software.amazon.awssdk.services.inspector2.model.AggregationType
}
object AggregationType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.AggregationType
  ): zio.aws.inspector2.model.AggregationType = value match {
    case software.amazon.awssdk.services.inspector2.model.AggregationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.FINDING_TYPE =>
      val r = FINDING_TYPE
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.PACKAGE =>
      val r = PACKAGE
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.TITLE =>
      val r = TITLE
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.REPOSITORY =>
      val r = REPOSITORY
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.AMI =>
      val r = AMI
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.AWS_EC2_INSTANCE =>
      val r = AWS_EC2_INSTANCE
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.AWS_ECR_CONTAINER =>
      val r = AWS_ECR_CONTAINER
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.IMAGE_LAYER =>
      val r = IMAGE_LAYER
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationType.ACCOUNT =>
      val r = ACCOUNT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.UNKNOWN_TO_SDK_VERSION
  }
  case object FINDING_TYPE extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.FINDING_TYPE
  }
  case object PACKAGE extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.PACKAGE
  }
  case object TITLE extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.TITLE
  }
  case object REPOSITORY extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.REPOSITORY
  }
  case object AMI extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.AMI
  }
  case object AWS_EC2_INSTANCE
      extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.AWS_EC2_INSTANCE
  }
  case object AWS_ECR_CONTAINER
      extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.AWS_ECR_CONTAINER
  }
  case object IMAGE_LAYER extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.IMAGE_LAYER
  }
  case object ACCOUNT extends zio.aws.inspector2.model.AggregationType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationType =
      software.amazon.awssdk.services.inspector2.model.AggregationType.ACCOUNT
  }
}
