package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters._
final case class RepositoryAggregationResponse(
    accountId: Option[AccountId] = None,
    affectedImages: Option[Long] = None,
    repository: NonEmptyString,
    severityCounts: Option[zio.aws.inspector2.model.SeverityCounts] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.RepositoryAggregationResponse = {
    import RepositoryAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.RepositoryAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(affectedImages.map(value => value: java.lang.Long))(
        _.affectedImages
      )
      .repository(NonEmptyString.unwrap(repository): java.lang.String)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.RepositoryAggregationResponse.wrap(buildAwsValue())
}
object RepositoryAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.RepositoryAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.RepositoryAggregationResponse =
      zio.aws.inspector2.model.RepositoryAggregationResponse(
        accountId.map(value => value),
        affectedImages.map(value => value),
        repository,
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Option[AccountId]
    def affectedImages: Option[Long]
    def repository: NonEmptyString
    def severityCounts: Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAffectedImages: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("affectedImages", affectedImages)
    def getRepository: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(repository)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.RepositoryAggregationResponse
  ) extends zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val affectedImages: Option[Long] =
      scala.Option(impl.affectedImages()).map(value => value: Long)
    override val repository: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.repository())
    override val severityCounts
        : Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly] = scala
      .Option(impl.severityCounts())
      .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.RepositoryAggregationResponse
  ): zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
