package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResourceStatus(
    ec2: zio.aws.inspector2.model.Status,
    ecr: zio.aws.inspector2.model.Status
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceStatus = {
    import ResourceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceStatus
      .builder()
      .ec2(ec2.unwrap)
      .ecr(ecr.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceStatus.ReadOnly =
    zio.aws.inspector2.model.ResourceStatus.wrap(buildAwsValue())
}
object ResourceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceStatus =
      zio.aws.inspector2.model.ResourceStatus(ec2, ecr)
    def ec2: zio.aws.inspector2.model.Status
    def ecr: zio.aws.inspector2.model.Status
    def getEc2: ZIO[Any, Nothing, zio.aws.inspector2.model.Status] =
      ZIO.succeed(ec2)
    def getEcr: ZIO[Any, Nothing, zio.aws.inspector2.model.Status] =
      ZIO.succeed(ecr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceStatus
  ) extends zio.aws.inspector2.model.ResourceStatus.ReadOnly {
    override val ec2: zio.aws.inspector2.model.Status =
      zio.aws.inspector2.model.Status.wrap(impl.ec2())
    override val ecr: zio.aws.inspector2.model.Status =
      zio.aws.inspector2.model.Status.wrap(impl.ecr())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceStatus
  ): zio.aws.inspector2.model.ResourceStatus.ReadOnly = new Wrapper(impl)
}
