package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Permission(
    operation: zio.aws.inspector2.model.Operation,
    service: zio.aws.inspector2.model.Service
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Permission = {
    import Permission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Permission
      .builder()
      .operation(operation.unwrap)
      .service(service.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Permission.ReadOnly =
    zio.aws.inspector2.model.Permission.wrap(buildAwsValue())
}
object Permission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Permission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Permission =
      zio.aws.inspector2.model.Permission(operation, service)
    def operation: zio.aws.inspector2.model.Operation
    def service: zio.aws.inspector2.model.Service
    def getOperation: ZIO[Any, Nothing, zio.aws.inspector2.model.Operation] =
      ZIO.succeed(operation)
    def getService: ZIO[Any, Nothing, zio.aws.inspector2.model.Service] =
      ZIO.succeed(service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Permission
  ) extends zio.aws.inspector2.model.Permission.ReadOnly {
    override val operation: zio.aws.inspector2.model.Operation =
      zio.aws.inspector2.model.Operation.wrap(impl.operation())
    override val service: zio.aws.inspector2.model.Service =
      zio.aws.inspector2.model.Service.wrap(impl.service())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Permission
  ): zio.aws.inspector2.model.Permission.ReadOnly = new Wrapper(impl)
}
