package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait Operation {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Operation
}
object Operation {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Operation
  ): zio.aws.inspector2.model.Operation = value match {
    case software.amazon.awssdk.services.inspector2.model.Operation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Operation.ENABLE_SCANNING =>
      val r = ENABLE_SCANNING
      r
    case software.amazon.awssdk.services.inspector2.model.Operation.DISABLE_SCANNING =>
      val r = DISABLE_SCANNING
      r
    case software.amazon.awssdk.services.inspector2.model.Operation.ENABLE_REPOSITORY =>
      val r = ENABLE_REPOSITORY
      r
    case software.amazon.awssdk.services.inspector2.model.Operation.DISABLE_REPOSITORY =>
      val r = DISABLE_REPOSITORY
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Operation =
      software.amazon.awssdk.services.inspector2.model.Operation.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE_SCANNING extends zio.aws.inspector2.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Operation =
      software.amazon.awssdk.services.inspector2.model.Operation.ENABLE_SCANNING
  }
  case object DISABLE_SCANNING extends zio.aws.inspector2.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Operation =
      software.amazon.awssdk.services.inspector2.model.Operation.DISABLE_SCANNING
  }
  case object ENABLE_REPOSITORY extends zio.aws.inspector2.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Operation =
      software.amazon.awssdk.services.inspector2.model.Operation.ENABLE_REPOSITORY
  }
  case object DISABLE_REPOSITORY extends zio.aws.inspector2.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Operation =
      software.amazon.awssdk.services.inspector2.model.Operation.DISABLE_REPOSITORY
  }
}
