package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class DisableDelegatedAdminAccountRequest(
    delegatedAdminAccountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest = {
    import DisableDelegatedAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest
      .builder()
      .delegatedAdminAccountId(
        AccountId.unwrap(delegatedAdminAccountId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.DisableDelegatedAdminAccountRequest.ReadOnly =
    zio.aws.inspector2.model.DisableDelegatedAdminAccountRequest
      .wrap(buildAwsValue())
}
object DisableDelegatedAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.DisableDelegatedAdminAccountRequest =
      zio.aws.inspector2.model
        .DisableDelegatedAdminAccountRequest(delegatedAdminAccountId)
    def delegatedAdminAccountId: AccountId
    def getDelegatedAdminAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(delegatedAdminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest
  ) extends zio.aws.inspector2.model.DisableDelegatedAdminAccountRequest.ReadOnly {
    override val delegatedAdminAccountId: AccountId =
      zio.aws.inspector2.model.primitives
        .AccountId(impl.delegatedAdminAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest
  ): zio.aws.inspector2.model.DisableDelegatedAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
