package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{
  MapValue,
  MapKey,
  FilterName,
  FilterDescription
}
import scala.jdk.CollectionConverters._
final case class CreateFilterRequest(
    action: zio.aws.inspector2.model.FilterAction,
    description: Option[FilterDescription] = None,
    filterCriteria: zio.aws.inspector2.model.FilterCriteria,
    name: FilterName,
    tags: Option[Map[MapKey, MapValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CreateFilterRequest = {
    import CreateFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CreateFilterRequest
      .builder()
      .action(action.unwrap)
      .optionallyWith(
        description.map(value =>
          FilterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .filterCriteria(filterCriteria.buildAwsValue())
      .name(FilterName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CreateFilterRequest.ReadOnly =
    zio.aws.inspector2.model.CreateFilterRequest.wrap(buildAwsValue())
}
object CreateFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CreateFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CreateFilterRequest =
      zio.aws.inspector2.model.CreateFilterRequest(
        action,
        description.map(value => value),
        filterCriteria.asEditable,
        name,
        tags.map(value => value)
      )
    def action: zio.aws.inspector2.model.FilterAction
    def description: Option[FilterDescription]
    def filterCriteria: zio.aws.inspector2.model.FilterCriteria.ReadOnly
    def name: FilterName
    def tags: Option[Map[MapKey, MapValue]]
    def getAction: ZIO[Any, Nothing, zio.aws.inspector2.model.FilterAction] =
      ZIO.succeed(action)
    def getDescription: ZIO[Any, AwsError, FilterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFilterCriteria
        : ZIO[Any, Nothing, zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      ZIO.succeed(filterCriteria)
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CreateFilterRequest
  ) extends zio.aws.inspector2.model.CreateFilterRequest.ReadOnly {
    override val action: zio.aws.inspector2.model.FilterAction =
      zio.aws.inspector2.model.FilterAction.wrap(impl.action())
    override val description: Option[FilterDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.inspector2.model.primitives.FilterDescription(value)
      )
    override val filterCriteria
        : zio.aws.inspector2.model.FilterCriteria.ReadOnly =
      zio.aws.inspector2.model.FilterCriteria.wrap(impl.filterCriteria())
    override val name: FilterName =
      zio.aws.inspector2.model.primitives.FilterName(impl.name())
    override val tags: Option[Map[MapKey, MapValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.inspector2.model.primitives.MapKey(
              key
            ) -> zio.aws.inspector2.model.primitives.MapValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CreateFilterRequest
  ): zio.aws.inspector2.model.CreateFilterRequest.ReadOnly = new Wrapper(impl)
}
