package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{Path, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class UpdateEc2DeepInspectionConfigurationResponse(
    errorMessage: Optional[NonEmptyString] = Optional.Absent,
    orgPackagePaths: Optional[Iterable[Path]] = Optional.Absent,
    packagePaths: Optional[Iterable[Path]] = Optional.Absent,
    status: Optional[zio.aws.inspector2.model.Ec2DeepInspectionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse = {
    import UpdateEc2DeepInspectionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse
      .builder()
      .optionallyWith(
        errorMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(
        orgPackagePaths.map(value =>
          value.map { item =>
            Path.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.orgPackagePaths)
      .optionallyWith(
        packagePaths.map(value =>
          value.map { item =>
            Path.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.packagePaths)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse.ReadOnly =
    zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateEc2DeepInspectionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse =
      zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse(
        errorMessage.map(value => value),
        orgPackagePaths.map(value => value),
        packagePaths.map(value => value),
        status.map(value => value)
      )
    def errorMessage: Optional[NonEmptyString]
    def orgPackagePaths: Optional[List[Path]]
    def packagePaths: Optional[List[Path]]
    def status: Optional[zio.aws.inspector2.model.Ec2DeepInspectionStatus]
    def getErrorMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getOrgPackagePaths: ZIO[Any, AwsError, List[Path]] =
      AwsError.unwrapOptionField("orgPackagePaths", orgPackagePaths)
    def getPackagePaths: ZIO[Any, AwsError, List[Path]] =
      AwsError.unwrapOptionField("packagePaths", packagePaths)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Ec2DeepInspectionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse
  ) extends zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse.ReadOnly {
    override val errorMessage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val orgPackagePaths: Optional[List[Path]] = zio.aws.core.internal
      .optionalFromNullable(impl.orgPackagePaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Path(item)
        }.toList
      )
    override val packagePaths: Optional[List[Path]] = zio.aws.core.internal
      .optionalFromNullable(impl.packagePaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Path(item)
        }.toList
      )
    override val status
        : Optional[zio.aws.inspector2.model.Ec2DeepInspectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.inspector2.model.Ec2DeepInspectionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse
  ): zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
