package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{FindingArn, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class FindingDetailsError(
    errorCode: zio.aws.inspector2.model.FindingDetailsErrorCode,
    errorMessage: NonEmptyString,
    findingArn: FindingArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FindingDetailsError = {
    import FindingDetailsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FindingDetailsError
      .builder()
      .errorCode(errorCode.unwrap)
      .errorMessage(NonEmptyString.unwrap(errorMessage): java.lang.String)
      .findingArn(FindingArn.unwrap(findingArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FindingDetailsError.ReadOnly =
    zio.aws.inspector2.model.FindingDetailsError.wrap(buildAwsValue())
}
object FindingDetailsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FindingDetailsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FindingDetailsError =
      zio.aws.inspector2.model
        .FindingDetailsError(errorCode, errorMessage, findingArn)
    def errorCode: zio.aws.inspector2.model.FindingDetailsErrorCode
    def errorMessage: NonEmptyString
    def findingArn: FindingArn
    def getErrorCode
        : ZIO[Any, Nothing, zio.aws.inspector2.model.FindingDetailsErrorCode] =
      ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(errorMessage)
    def getFindingArn: ZIO[Any, Nothing, FindingArn] = ZIO.succeed(findingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FindingDetailsError
  ) extends zio.aws.inspector2.model.FindingDetailsError.ReadOnly {
    override val errorCode: zio.aws.inspector2.model.FindingDetailsErrorCode =
      zio.aws.inspector2.model.FindingDetailsErrorCode.wrap(impl.errorCode())
    override val errorMessage: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.errorMessage())
    override val findingArn: FindingArn =
      zio.aws.inspector2.model.primitives.FindingArn(impl.findingArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FindingDetailsError
  ): zio.aws.inspector2.model.FindingDetailsError.ReadOnly = new Wrapper(impl)
}
