package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EcrConfiguration(
    rescanDuration: zio.aws.inspector2.model.EcrRescanDuration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EcrConfiguration = {
    import EcrConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EcrConfiguration
      .builder()
      .rescanDuration(rescanDuration.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EcrConfiguration.ReadOnly =
    zio.aws.inspector2.model.EcrConfiguration.wrap(buildAwsValue())
}
object EcrConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EcrConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EcrConfiguration =
      zio.aws.inspector2.model.EcrConfiguration(rescanDuration)
    def rescanDuration: zio.aws.inspector2.model.EcrRescanDuration
    def getRescanDuration
        : ZIO[Any, Nothing, zio.aws.inspector2.model.EcrRescanDuration] =
      ZIO.succeed(rescanDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EcrConfiguration
  ) extends zio.aws.inspector2.model.EcrConfiguration.ReadOnly {
    override val rescanDuration: zio.aws.inspector2.model.EcrRescanDuration =
      zio.aws.inspector2.model.EcrRescanDuration.wrap(impl.rescanDuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EcrConfiguration
  ): zio.aws.inspector2.model.EcrConfiguration.ReadOnly = new Wrapper(impl)
}
