package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetCodeSnippetResponse(
    codeSnippetResults: Optional[
      Iterable[zio.aws.inspector2.model.CodeSnippetResult]
    ] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.inspector2.model.CodeSnippetError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse = {
    import BatchGetCodeSnippetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse
      .builder()
      .optionallyWith(
        codeSnippetResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeSnippetResults)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchGetCodeSnippetResponse.ReadOnly =
    zio.aws.inspector2.model.BatchGetCodeSnippetResponse.wrap(buildAwsValue())
}
object BatchGetCodeSnippetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.BatchGetCodeSnippetResponse =
      zio.aws.inspector2.model.BatchGetCodeSnippetResponse(
        codeSnippetResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def codeSnippetResults
        : Optional[List[zio.aws.inspector2.model.CodeSnippetResult.ReadOnly]]
    def errors
        : Optional[List[zio.aws.inspector2.model.CodeSnippetError.ReadOnly]]
    def getCodeSnippetResults: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CodeSnippetResult.ReadOnly
    ]] = AwsError.unwrapOptionField("codeSnippetResults", codeSnippetResults)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CodeSnippetError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse
  ) extends zio.aws.inspector2.model.BatchGetCodeSnippetResponse.ReadOnly {
    override val codeSnippetResults
        : Optional[List[zio.aws.inspector2.model.CodeSnippetResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeSnippetResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CodeSnippetResult.wrap(item)
          }.toList
        )
    override val errors
        : Optional[List[zio.aws.inspector2.model.CodeSnippetError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CodeSnippetError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse
  ): zio.aws.inspector2.model.BatchGetCodeSnippetResponse.ReadOnly =
    new Wrapper(impl)
}
