package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceScanMetadata(
    ec2: Optional[zio.aws.inspector2.model.Ec2Metadata] = Optional.Absent,
    ecrImage: Optional[zio.aws.inspector2.model.EcrContainerImageMetadata] =
      Optional.Absent,
    ecrRepository: Optional[zio.aws.inspector2.model.EcrRepositoryMetadata] =
      Optional.Absent,
    lambdaFunction: Optional[zio.aws.inspector2.model.LambdaFunctionMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata = {
    import ResourceScanMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata
      .builder()
      .optionallyWith(ec2.map(value => value.buildAwsValue()))(_.ec2)
      .optionallyWith(ecrImage.map(value => value.buildAwsValue()))(_.ecrImage)
      .optionallyWith(ecrRepository.map(value => value.buildAwsValue()))(
        _.ecrRepository
      )
      .optionallyWith(lambdaFunction.map(value => value.buildAwsValue()))(
        _.lambdaFunction
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly =
    zio.aws.inspector2.model.ResourceScanMetadata.wrap(buildAwsValue())
}
object ResourceScanMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceScanMetadata =
      zio.aws.inspector2.model.ResourceScanMetadata(
        ec2.map(value => value.asEditable),
        ecrImage.map(value => value.asEditable),
        ecrRepository.map(value => value.asEditable),
        lambdaFunction.map(value => value.asEditable)
      )
    def ec2: Optional[zio.aws.inspector2.model.Ec2Metadata.ReadOnly]
    def ecrImage
        : Optional[zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly]
    def ecrRepository
        : Optional[zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly]
    def lambdaFunction
        : Optional[zio.aws.inspector2.model.LambdaFunctionMetadata.ReadOnly]
    def getEc2
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Ec2Metadata.ReadOnly] =
      AwsError.unwrapOptionField("ec2", ec2)
    def getEcrImage: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("ecrImage", ecrImage)
    def getEcrRepository: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("ecrRepository", ecrRepository)
    def getLambdaFunction: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.LambdaFunctionMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaFunction", lambdaFunction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata
  ) extends zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly {
    override val ec2: Optional[zio.aws.inspector2.model.Ec2Metadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2())
        .map(value => zio.aws.inspector2.model.Ec2Metadata.wrap(value))
    override val ecrImage: Optional[
      zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecrImage())
      .map(value =>
        zio.aws.inspector2.model.EcrContainerImageMetadata.wrap(value)
      )
    override val ecrRepository
        : Optional[zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrRepository())
        .map(value =>
          zio.aws.inspector2.model.EcrRepositoryMetadata.wrap(value)
        )
    override val lambdaFunction
        : Optional[zio.aws.inspector2.model.LambdaFunctionMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaFunction())
        .map(value =>
          zio.aws.inspector2.model.LambdaFunctionMetadata.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata
  ): zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly = new Wrapper(impl)
}
