package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.ListUsageTotalsNextToken
import scala.jdk.CollectionConverters._
final case class ListUsageTotalsResponse(
    nextToken: Optional[ListUsageTotalsNextToken] = Optional.Absent,
    totals: Optional[Iterable[zio.aws.inspector2.model.UsageTotal]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse = {
    import ListUsageTotalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          ListUsageTotalsNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        totals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.totals)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListUsageTotalsResponse.ReadOnly =
    zio.aws.inspector2.model.ListUsageTotalsResponse.wrap(buildAwsValue())
}
object ListUsageTotalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListUsageTotalsResponse =
      zio.aws.inspector2.model.ListUsageTotalsResponse(
        nextToken.map(value => value),
        totals.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[ListUsageTotalsNextToken]
    def totals: Optional[List[zio.aws.inspector2.model.UsageTotal.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, ListUsageTotalsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotals: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.UsageTotal.ReadOnly
    ]] = AwsError.unwrapOptionField("totals", totals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse
  ) extends zio.aws.inspector2.model.ListUsageTotalsResponse.ReadOnly {
    override val nextToken: Optional[ListUsageTotalsNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.inspector2.model.primitives.ListUsageTotalsNextToken(value)
        )
    override val totals
        : Optional[List[zio.aws.inspector2.model.UsageTotal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.UsageTotal.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse
  ): zio.aws.inspector2.model.ListUsageTotalsResponse.ReadOnly = new Wrapper(
    impl
  )
}
