package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait FreeTrialStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.FreeTrialStatus
}
object FreeTrialStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.FreeTrialStatus
  ): zio.aws.inspector2.model.FreeTrialStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.FreeTrialStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.FreeTrialStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.inspector2.model.FreeTrialStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.FreeTrialStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialStatus =
      software.amazon.awssdk.services.inspector2.model.FreeTrialStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.inspector2.model.FreeTrialStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialStatus =
      software.amazon.awssdk.services.inspector2.model.FreeTrialStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.inspector2.model.FreeTrialStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialStatus =
      software.amazon.awssdk.services.inspector2.model.FreeTrialStatus.INACTIVE
  }
}
