package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{MapValue, MapKey, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class Resource(
    details: Optional[zio.aws.inspector2.model.ResourceDetails] =
      Optional.Absent,
    id: NonEmptyString,
    partition: Optional[NonEmptyString] = Optional.Absent,
    region: Optional[NonEmptyString] = Optional.Absent,
    tags: Optional[Map[MapKey, MapValue]] = Optional.Absent,
    `type`: zio.aws.inspector2.model.ResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Resource
      .builder()
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .optionallyWith(
        partition.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.partition)
      .optionallyWith(
        region.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Resource.ReadOnly =
    zio.aws.inspector2.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Resource =
      zio.aws.inspector2.model.Resource(
        details.map(value => value.asEditable),
        id,
        partition.map(value => value),
        region.map(value => value),
        tags.map(value => value),
        `type`
      )
    def details: Optional[zio.aws.inspector2.model.ResourceDetails.ReadOnly]
    def id: NonEmptyString
    def partition: Optional[NonEmptyString]
    def region: Optional[NonEmptyString]
    def tags: Optional[Map[MapKey, MapValue]]
    def `type`: zio.aws.inspector2.model.ResourceType
    def getDetails: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ResourceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("details", details)
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getPartition: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("partition", partition)
    def getRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("region", region)
    def getTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.inspector2.model.ResourceType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Resource
  ) extends zio.aws.inspector2.model.Resource.ReadOnly {
    override val details
        : Optional[zio.aws.inspector2.model.ResourceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.details())
        .map(value => zio.aws.inspector2.model.ResourceDetails.wrap(value))
    override val id: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.id())
    override val partition: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.partition())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val region: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val tags: Optional[Map[MapKey, MapValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.inspector2.model.primitives.MapKey(
              key
            ) -> zio.aws.inspector2.model.primitives.MapValue(value)
          })
          .toMap
      )
    override val `type`: zio.aws.inspector2.model.ResourceType =
      zio.aws.inspector2.model.ResourceType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Resource
  ): zio.aws.inspector2.model.Resource.ReadOnly = new Wrapper(impl)
}
