package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{Cvss2ScoringVector, Cvss2BaseScore}
import scala.jdk.CollectionConverters._
final case class Cvss2(
    baseScore: Optional[Cvss2BaseScore] = Optional.Absent,
    scoringVector: Optional[Cvss2ScoringVector] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Cvss2 = {
    import Cvss2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Cvss2
      .builder()
      .optionallyWith(
        baseScore.map(value => Cvss2BaseScore.unwrap(value): java.lang.Double)
      )(_.baseScore)
      .optionallyWith(
        scoringVector.map(value =>
          Cvss2ScoringVector.unwrap(value): java.lang.String
        )
      )(_.scoringVector)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Cvss2.ReadOnly =
    zio.aws.inspector2.model.Cvss2.wrap(buildAwsValue())
}
object Cvss2 {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Cvss2] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Cvss2 = zio.aws.inspector2.model
      .Cvss2(baseScore.map(value => value), scoringVector.map(value => value))
    def baseScore: Optional[Cvss2BaseScore]
    def scoringVector: Optional[Cvss2ScoringVector]
    def getBaseScore: ZIO[Any, AwsError, Cvss2BaseScore] =
      AwsError.unwrapOptionField("baseScore", baseScore)
    def getScoringVector: ZIO[Any, AwsError, Cvss2ScoringVector] =
      AwsError.unwrapOptionField("scoringVector", scoringVector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Cvss2
  ) extends zio.aws.inspector2.model.Cvss2.ReadOnly {
    override val baseScore: Optional[Cvss2BaseScore] = zio.aws.core.internal
      .optionalFromNullable(impl.baseScore())
      .map(value => zio.aws.inspector2.model.primitives.Cvss2BaseScore(value))
    override val scoringVector: Optional[Cvss2ScoringVector] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scoringVector())
        .map(value =>
          zio.aws.inspector2.model.primitives.Cvss2ScoringVector(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Cvss2
  ): zio.aws.inspector2.model.Cvss2.ReadOnly = new Wrapper(impl)
}
