package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  VulnerabilitySourceUrl,
  Cwe,
  VulnerabilityReferenceUrl,
  VendorUpdatedAt,
  VulnerabilityDescription,
  RelatedVulnerability,
  VendorCreatedAt,
  VendorSeverity,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Vulnerability(
    atigData: Optional[zio.aws.inspector2.model.AtigData] = Optional.Absent,
    cisaData: Optional[zio.aws.inspector2.model.CisaData] = Optional.Absent,
    cvss2: Optional[zio.aws.inspector2.model.Cvss2] = Optional.Absent,
    cvss3: Optional[zio.aws.inspector2.model.Cvss3] = Optional.Absent,
    cwes: Optional[Iterable[Cwe]] = Optional.Absent,
    description: Optional[VulnerabilityDescription] = Optional.Absent,
    detectionPlatforms: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    epss: Optional[zio.aws.inspector2.model.Epss] = Optional.Absent,
    exploitObserved: Optional[zio.aws.inspector2.model.ExploitObserved] =
      Optional.Absent,
    id: NonEmptyString,
    referenceUrls: Optional[Iterable[VulnerabilityReferenceUrl]] =
      Optional.Absent,
    relatedVulnerabilities: Optional[Iterable[RelatedVulnerability]] =
      Optional.Absent,
    source: Optional[zio.aws.inspector2.model.VulnerabilitySource] =
      Optional.Absent,
    sourceUrl: Optional[VulnerabilitySourceUrl] = Optional.Absent,
    vendorCreatedAt: Optional[VendorCreatedAt] = Optional.Absent,
    vendorSeverity: Optional[VendorSeverity] = Optional.Absent,
    vendorUpdatedAt: Optional[VendorUpdatedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Vulnerability = {
    import Vulnerability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Vulnerability
      .builder()
      .optionallyWith(atigData.map(value => value.buildAwsValue()))(_.atigData)
      .optionallyWith(cisaData.map(value => value.buildAwsValue()))(_.cisaData)
      .optionallyWith(cvss2.map(value => value.buildAwsValue()))(_.cvss2)
      .optionallyWith(cvss3.map(value => value.buildAwsValue()))(_.cvss3)
      .optionallyWith(
        cwes.map(value =>
          value.map { item =>
            Cwe.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cwes)
      .optionallyWith(
        description.map(value =>
          VulnerabilityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        detectionPlatforms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.detectionPlatforms)
      .optionallyWith(epss.map(value => value.buildAwsValue()))(_.epss)
      .optionallyWith(exploitObserved.map(value => value.buildAwsValue()))(
        _.exploitObserved
      )
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .optionallyWith(
        referenceUrls.map(value =>
          value.map { item =>
            VulnerabilityReferenceUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.referenceUrls)
      .optionallyWith(
        relatedVulnerabilities.map(value =>
          value.map { item =>
            RelatedVulnerability.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedVulnerabilities)
      .optionallyWith(source.map(value => value.unwrap))(_.source)
      .optionallyWith(
        sourceUrl.map(value =>
          VulnerabilitySourceUrl.unwrap(value): java.lang.String
        )
      )(_.sourceUrl)
      .optionallyWith(
        vendorCreatedAt.map(value => VendorCreatedAt.unwrap(value): Instant)
      )(_.vendorCreatedAt)
      .optionallyWith(
        vendorSeverity.map(value =>
          VendorSeverity.unwrap(value): java.lang.String
        )
      )(_.vendorSeverity)
      .optionallyWith(
        vendorUpdatedAt.map(value => VendorUpdatedAt.unwrap(value): Instant)
      )(_.vendorUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Vulnerability.ReadOnly =
    zio.aws.inspector2.model.Vulnerability.wrap(buildAwsValue())
}
object Vulnerability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Vulnerability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Vulnerability =
      zio.aws.inspector2.model.Vulnerability(
        atigData.map(value => value.asEditable),
        cisaData.map(value => value.asEditable),
        cvss2.map(value => value.asEditable),
        cvss3.map(value => value.asEditable),
        cwes.map(value => value),
        description.map(value => value),
        detectionPlatforms.map(value => value),
        epss.map(value => value.asEditable),
        exploitObserved.map(value => value.asEditable),
        id,
        referenceUrls.map(value => value),
        relatedVulnerabilities.map(value => value),
        source.map(value => value),
        sourceUrl.map(value => value),
        vendorCreatedAt.map(value => value),
        vendorSeverity.map(value => value),
        vendorUpdatedAt.map(value => value)
      )
    def atigData: Optional[zio.aws.inspector2.model.AtigData.ReadOnly]
    def cisaData: Optional[zio.aws.inspector2.model.CisaData.ReadOnly]
    def cvss2: Optional[zio.aws.inspector2.model.Cvss2.ReadOnly]
    def cvss3: Optional[zio.aws.inspector2.model.Cvss3.ReadOnly]
    def cwes: Optional[List[Cwe]]
    def description: Optional[VulnerabilityDescription]
    def detectionPlatforms: Optional[List[NonEmptyString]]
    def epss: Optional[zio.aws.inspector2.model.Epss.ReadOnly]
    def exploitObserved
        : Optional[zio.aws.inspector2.model.ExploitObserved.ReadOnly]
    def id: NonEmptyString
    def referenceUrls: Optional[List[VulnerabilityReferenceUrl]]
    def relatedVulnerabilities: Optional[List[RelatedVulnerability]]
    def source: Optional[zio.aws.inspector2.model.VulnerabilitySource]
    def sourceUrl: Optional[VulnerabilitySourceUrl]
    def vendorCreatedAt: Optional[VendorCreatedAt]
    def vendorSeverity: Optional[VendorSeverity]
    def vendorUpdatedAt: Optional[VendorUpdatedAt]
    def getAtigData
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AtigData.ReadOnly] =
      AwsError.unwrapOptionField("atigData", atigData)
    def getCisaData
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisaData.ReadOnly] =
      AwsError.unwrapOptionField("cisaData", cisaData)
    def getCvss2: ZIO[Any, AwsError, zio.aws.inspector2.model.Cvss2.ReadOnly] =
      AwsError.unwrapOptionField("cvss2", cvss2)
    def getCvss3: ZIO[Any, AwsError, zio.aws.inspector2.model.Cvss3.ReadOnly] =
      AwsError.unwrapOptionField("cvss3", cvss3)
    def getCwes: ZIO[Any, AwsError, List[Cwe]] =
      AwsError.unwrapOptionField("cwes", cwes)
    def getDescription: ZIO[Any, AwsError, VulnerabilityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDetectionPlatforms: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("detectionPlatforms", detectionPlatforms)
    def getEpss: ZIO[Any, AwsError, zio.aws.inspector2.model.Epss.ReadOnly] =
      AwsError.unwrapOptionField("epss", epss)
    def getExploitObserved: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ExploitObserved.ReadOnly
    ] = AwsError.unwrapOptionField("exploitObserved", exploitObserved)
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getReferenceUrls: ZIO[Any, AwsError, List[VulnerabilityReferenceUrl]] =
      AwsError.unwrapOptionField("referenceUrls", referenceUrls)
    def getRelatedVulnerabilities
        : ZIO[Any, AwsError, List[RelatedVulnerability]] = AwsError
      .unwrapOptionField("relatedVulnerabilities", relatedVulnerabilities)
    def getSource
        : ZIO[Any, AwsError, zio.aws.inspector2.model.VulnerabilitySource] =
      AwsError.unwrapOptionField("source", source)
    def getSourceUrl: ZIO[Any, AwsError, VulnerabilitySourceUrl] =
      AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getVendorCreatedAt: ZIO[Any, AwsError, VendorCreatedAt] =
      AwsError.unwrapOptionField("vendorCreatedAt", vendorCreatedAt)
    def getVendorSeverity: ZIO[Any, AwsError, VendorSeverity] =
      AwsError.unwrapOptionField("vendorSeverity", vendorSeverity)
    def getVendorUpdatedAt: ZIO[Any, AwsError, VendorUpdatedAt] =
      AwsError.unwrapOptionField("vendorUpdatedAt", vendorUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Vulnerability
  ) extends zio.aws.inspector2.model.Vulnerability.ReadOnly {
    override val atigData
        : Optional[zio.aws.inspector2.model.AtigData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.atigData())
        .map(value => zio.aws.inspector2.model.AtigData.wrap(value))
    override val cisaData
        : Optional[zio.aws.inspector2.model.CisaData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cisaData())
        .map(value => zio.aws.inspector2.model.CisaData.wrap(value))
    override val cvss2: Optional[zio.aws.inspector2.model.Cvss2.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cvss2())
        .map(value => zio.aws.inspector2.model.Cvss2.wrap(value))
    override val cvss3: Optional[zio.aws.inspector2.model.Cvss3.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cvss3())
        .map(value => zio.aws.inspector2.model.Cvss3.wrap(value))
    override val cwes: Optional[List[Cwe]] = zio.aws.core.internal
      .optionalFromNullable(impl.cwes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Cwe(item)
        }.toList
      )
    override val description: Optional[VulnerabilityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.inspector2.model.primitives.VulnerabilityDescription(value)
        )
    override val detectionPlatforms: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detectionPlatforms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val epss: Optional[zio.aws.inspector2.model.Epss.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.epss())
        .map(value => zio.aws.inspector2.model.Epss.wrap(value))
    override val exploitObserved
        : Optional[zio.aws.inspector2.model.ExploitObserved.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exploitObserved())
        .map(value => zio.aws.inspector2.model.ExploitObserved.wrap(value))
    override val id: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.id())
    override val referenceUrls: Optional[List[VulnerabilityReferenceUrl]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceUrls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.VulnerabilityReferenceUrl(item)
          }.toList
        )
    override val relatedVulnerabilities: Optional[List[RelatedVulnerability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedVulnerabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.RelatedVulnerability(item)
          }.toList
        )
    override val source
        : Optional[zio.aws.inspector2.model.VulnerabilitySource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.inspector2.model.VulnerabilitySource.wrap(value))
    override val sourceUrl: Optional[VulnerabilitySourceUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceUrl())
        .map(value =>
          zio.aws.inspector2.model.primitives.VulnerabilitySourceUrl(value)
        )
    override val vendorCreatedAt: Optional[VendorCreatedAt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorCreatedAt())
        .map(value =>
          zio.aws.inspector2.model.primitives.VendorCreatedAt(value)
        )
    override val vendorSeverity: Optional[VendorSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorSeverity())
        .map(value => zio.aws.inspector2.model.primitives.VendorSeverity(value))
    override val vendorUpdatedAt: Optional[VendorUpdatedAt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorUpdatedAt())
        .map(value =>
          zio.aws.inspector2.model.primitives.VendorUpdatedAt(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Vulnerability
  ): zio.aws.inspector2.model.Vulnerability.ReadOnly = new Wrapper(impl)
}
