package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait SortField {
  def unwrap: software.amazon.awssdk.services.inspector2.model.SortField
}
object SortField {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.SortField
  ): zio.aws.inspector2.model.SortField = value match {
    case software.amazon.awssdk.services.inspector2.model.SortField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.AWS_ACCOUNT_ID =>
      val r = AWS_ACCOUNT_ID
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.FINDING_TYPE =>
      val r = FINDING_TYPE
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.SEVERITY =>
      val r = SEVERITY
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.FIRST_OBSERVED_AT =>
      val r = FIRST_OBSERVED_AT
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.LAST_OBSERVED_AT =>
      val r = LAST_OBSERVED_AT
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.FINDING_STATUS =>
      val r = FINDING_STATUS
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.RESOURCE_TYPE =>
      val r = RESOURCE_TYPE
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.ECR_IMAGE_PUSHED_AT =>
      val r = ECR_IMAGE_PUSHED_AT
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.ECR_IMAGE_REPOSITORY_NAME =>
      val r = ECR_IMAGE_REPOSITORY_NAME
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.ECR_IMAGE_REGISTRY =>
      val r = ECR_IMAGE_REGISTRY
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.NETWORK_PROTOCOL =>
      val r = NETWORK_PROTOCOL
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.COMPONENT_TYPE =>
      val r = COMPONENT_TYPE
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.VULNERABILITY_ID =>
      val r = VULNERABILITY_ID
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.VULNERABILITY_SOURCE =>
      val r = VULNERABILITY_SOURCE
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.INSPECTOR_SCORE =>
      val r = INSPECTOR_SCORE
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.VENDOR_SEVERITY =>
      val r = VENDOR_SEVERITY
      r
    case software.amazon.awssdk.services.inspector2.model.SortField.EPSS_SCORE =>
      val r = EPSS_SCORE
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_ACCOUNT_ID extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.AWS_ACCOUNT_ID
  }
  case object FINDING_TYPE extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.FINDING_TYPE
  }
  case object SEVERITY extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.SEVERITY
  }
  case object FIRST_OBSERVED_AT extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.FIRST_OBSERVED_AT
  }
  case object LAST_OBSERVED_AT extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.LAST_OBSERVED_AT
  }
  case object FINDING_STATUS extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.FINDING_STATUS
  }
  case object RESOURCE_TYPE extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.RESOURCE_TYPE
  }
  case object ECR_IMAGE_PUSHED_AT extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.ECR_IMAGE_PUSHED_AT
  }
  case object ECR_IMAGE_REPOSITORY_NAME
      extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.ECR_IMAGE_REPOSITORY_NAME
  }
  case object ECR_IMAGE_REGISTRY extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.ECR_IMAGE_REGISTRY
  }
  case object NETWORK_PROTOCOL extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.NETWORK_PROTOCOL
  }
  case object COMPONENT_TYPE extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.COMPONENT_TYPE
  }
  case object VULNERABILITY_ID extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.VULNERABILITY_ID
  }
  case object VULNERABILITY_SOURCE extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.VULNERABILITY_SOURCE
  }
  case object INSPECTOR_SCORE extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.INSPECTOR_SCORE
  }
  case object VENDOR_SEVERITY extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.VENDOR_SEVERITY
  }
  case object EPSS_SCORE extends zio.aws.inspector2.model.SortField {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortField =
      software.amazon.awssdk.services.inspector2.model.SortField.EPSS_SCORE
  }
}
