package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkPath(
    steps: Optional[Iterable[zio.aws.inspector2.model.Step]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.NetworkPath = {
    import NetworkPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.NetworkPath
      .builder()
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.NetworkPath.ReadOnly =
    zio.aws.inspector2.model.NetworkPath.wrap(buildAwsValue())
}
object NetworkPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.NetworkPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.NetworkPath =
      zio.aws.inspector2.model.NetworkPath(
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def steps: Optional[List[zio.aws.inspector2.model.Step.ReadOnly]]
    def getSteps
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.Step.ReadOnly]] =
      AwsError.unwrapOptionField("steps", steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.NetworkPath
  ) extends zio.aws.inspector2.model.NetworkPath.ReadOnly {
    override val steps: Optional[List[zio.aws.inspector2.model.Step.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.steps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.Step.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.NetworkPath
  ): zio.aws.inspector2.model.NetworkPath.ReadOnly = new Wrapper(impl)
}
