package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LambdaFunctionAggregation(
    functionNames: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    functionTags: Optional[Iterable[zio.aws.inspector2.model.MapFilter]] =
      Optional.Absent,
    resourceIds: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    runtimes: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.LambdaFunctionSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregation = {
    import LambdaFunctionAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregation
      .builder()
      .optionallyWith(
        functionNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.functionNames)
      .optionallyWith(
        functionTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.functionTags)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIds)
      .optionallyWith(
        runtimes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runtimes)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.LambdaFunctionAggregation.ReadOnly =
    zio.aws.inspector2.model.LambdaFunctionAggregation.wrap(buildAwsValue())
}
object LambdaFunctionAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.LambdaFunctionAggregation =
      zio.aws.inspector2.model.LambdaFunctionAggregation(
        functionNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        functionTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        runtimes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def functionNames
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def functionTags
        : Optional[List[zio.aws.inspector2.model.MapFilter.ReadOnly]]
    def resourceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def runtimes: Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Optional[zio.aws.inspector2.model.LambdaFunctionSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def getFunctionNames: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("functionNames", functionNames)
    def getFunctionTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("functionTags", functionTags)
    def getResourceIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIds", resourceIds)
    def getRuntimes: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("runtimes", runtimes)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.LambdaFunctionSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregation
  ) extends zio.aws.inspector2.model.LambdaFunctionAggregation.ReadOnly {
    override val functionNames
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val functionTags
        : Optional[List[zio.aws.inspector2.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.MapFilter.wrap(item)
          }.toList
        )
    override val resourceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val runtimes
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val sortBy
        : Optional[zio.aws.inspector2.model.LambdaFunctionSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.LambdaFunctionSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregation
  ): zio.aws.inspector2.model.LambdaFunctionAggregation.ReadOnly = new Wrapper(
    impl
  )
}
