package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{VpcId, SubnetId, SecurityGroupId}
import scala.jdk.CollectionConverters._
final case class LambdaVpcConfig(
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.LambdaVpcConfig = {
    import LambdaVpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.LambdaVpcConfig
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.LambdaVpcConfig.ReadOnly =
    zio.aws.inspector2.model.LambdaVpcConfig.wrap(buildAwsValue())
}
object LambdaVpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.LambdaVpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.LambdaVpcConfig =
      zio.aws.inspector2.model.LambdaVpcConfig(
        securityGroupIds.map(value => value),
        subnetIds.map(value => value),
        vpcId.map(value => value)
      )
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def subnetIds: Optional[List[SubnetId]]
    def vpcId: Optional[VpcId]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaVpcConfig
  ) extends zio.aws.inspector2.model.LambdaVpcConfig.ReadOnly {
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.SubnetId(item)
        }.toList
      )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.inspector2.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaVpcConfig
  ): zio.aws.inspector2.model.LambdaVpcConfig.ReadOnly = new Wrapper(impl)
}
