package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.FilterArn
import scala.jdk.CollectionConverters._
final case class UpdateFilterResponse(arn: FilterArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse = {
    import UpdateFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse
      .builder()
      .arn(FilterArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UpdateFilterResponse.ReadOnly =
    zio.aws.inspector2.model.UpdateFilterResponse.wrap(buildAwsValue())
}
object UpdateFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UpdateFilterResponse =
      zio.aws.inspector2.model.UpdateFilterResponse(arn)
    def arn: FilterArn
    def getArn: ZIO[Any, Nothing, FilterArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse
  ) extends zio.aws.inspector2.model.UpdateFilterResponse.ReadOnly {
    override val arn: FilterArn =
      zio.aws.inspector2.model.primitives.FilterArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse
  ): zio.aws.inspector2.model.UpdateFilterResponse.ReadOnly = new Wrapper(impl)
}
