package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListFindingAggregationsResponse(
    aggregationType: zio.aws.inspector2.model.AggregationType,
    nextToken: Optional[NextToken] = Optional.Absent,
    responses: Optional[
      Iterable[zio.aws.inspector2.model.AggregationResponse]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse = {
    import ListFindingAggregationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse
      .builder()
      .aggregationType(aggregationType.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListFindingAggregationsResponse.ReadOnly =
    zio.aws.inspector2.model.ListFindingAggregationsResponse
      .wrap(buildAwsValue())
}
object ListFindingAggregationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListFindingAggregationsResponse =
      zio.aws.inspector2.model.ListFindingAggregationsResponse(
        aggregationType,
        nextToken.map(value => value),
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def aggregationType: zio.aws.inspector2.model.AggregationType
    def nextToken: Optional[NextToken]
    def responses
        : Optional[List[zio.aws.inspector2.model.AggregationResponse.ReadOnly]]
    def getAggregationType
        : ZIO[Any, Nothing, zio.aws.inspector2.model.AggregationType] =
      ZIO.succeed(aggregationType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.AggregationResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse
  ) extends zio.aws.inspector2.model.ListFindingAggregationsResponse.ReadOnly {
    override val aggregationType: zio.aws.inspector2.model.AggregationType =
      zio.aws.inspector2.model.AggregationType.wrap(impl.aggregationType())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val responses: Optional[
      List[zio.aws.inspector2.model.AggregationResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.AggregationResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse
  ): zio.aws.inspector2.model.ListFindingAggregationsResponse.ReadOnly =
    new Wrapper(impl)
}
