package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ScanStatus(
    reason: zio.aws.inspector2.model.ScanStatusReason,
    statusCode: zio.aws.inspector2.model.ScanStatusCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ScanStatus = {
    import ScanStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ScanStatus
      .builder()
      .reason(reason.unwrap)
      .statusCode(statusCode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ScanStatus.ReadOnly =
    zio.aws.inspector2.model.ScanStatus.wrap(buildAwsValue())
}
object ScanStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ScanStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ScanStatus =
      zio.aws.inspector2.model.ScanStatus(reason, statusCode)
    def reason: zio.aws.inspector2.model.ScanStatusReason
    def statusCode: zio.aws.inspector2.model.ScanStatusCode
    def getReason
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ScanStatusReason] =
      ZIO.succeed(reason)
    def getStatusCode
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ScanStatusCode] =
      ZIO.succeed(statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ScanStatus
  ) extends zio.aws.inspector2.model.ScanStatus.ReadOnly {
    override val reason: zio.aws.inspector2.model.ScanStatusReason =
      zio.aws.inspector2.model.ScanStatusReason.wrap(impl.reason())
    override val statusCode: zio.aws.inspector2.model.ScanStatusCode =
      zio.aws.inspector2.model.ScanStatusCode.wrap(impl.statusCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ScanStatus
  ): zio.aws.inspector2.model.ScanStatus.ReadOnly = new Wrapper(impl)
}
