package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class CvssScore(
    baseScore: Double,
    scoringVector: NonEmptyString,
    source: NonEmptyString,
    version: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CvssScore = {
    import CvssScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CvssScore
      .builder()
      .baseScore(baseScore: java.lang.Double)
      .scoringVector(NonEmptyString.unwrap(scoringVector): java.lang.String)
      .source(NonEmptyString.unwrap(source): java.lang.String)
      .version(NonEmptyString.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CvssScore.ReadOnly =
    zio.aws.inspector2.model.CvssScore.wrap(buildAwsValue())
}
object CvssScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CvssScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CvssScore =
      zio.aws.inspector2.model.CvssScore(
        baseScore,
        scoringVector,
        source,
        version
      )
    def baseScore: Double
    def scoringVector: NonEmptyString
    def source: NonEmptyString
    def version: NonEmptyString
    def getBaseScore: ZIO[Any, Nothing, Double] = ZIO.succeed(baseScore)
    def getScoringVector: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(scoringVector)
    def getSource: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(source)
    def getVersion: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CvssScore
  ) extends zio.aws.inspector2.model.CvssScore.ReadOnly {
    override val baseScore: Double = impl.baseScore(): Double
    override val scoringVector: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.scoringVector())
    override val source: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.source())
    override val version: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CvssScore
  ): zio.aws.inspector2.model.CvssScore.ReadOnly = new Wrapper(impl)
}
