package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class AssociateMemberRequest(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest = {
    import AssociateMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AssociateMemberRequest.ReadOnly =
    zio.aws.inspector2.model.AssociateMemberRequest.wrap(buildAwsValue())
}
object AssociateMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AssociateMemberRequest =
      zio.aws.inspector2.model.AssociateMemberRequest(accountId)
    def accountId: AccountId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest
  ) extends zio.aws.inspector2.model.AssociateMemberRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest
  ): zio.aws.inspector2.model.AssociateMemberRequest.ReadOnly = new Wrapper(
    impl
  )
}
