package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{ComponentType, Component}
import scala.jdk.CollectionConverters._
final case class Step(componentId: Component, componentType: ComponentType) {
  def buildAwsValue(): software.amazon.awssdk.services.inspector2.model.Step = {
    import Step.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Step
      .builder()
      .componentId(Component.unwrap(componentId): java.lang.String)
      .componentType(ComponentType.unwrap(componentType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Step.ReadOnly =
    zio.aws.inspector2.model.Step.wrap(buildAwsValue())
}
object Step {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Step] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Step =
      zio.aws.inspector2.model.Step(componentId, componentType)
    def componentId: Component
    def componentType: ComponentType
    def getComponentId: ZIO[Any, Nothing, Component] = ZIO.succeed(componentId)
    def getComponentType: ZIO[Any, Nothing, ComponentType] =
      ZIO.succeed(componentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Step
  ) extends zio.aws.inspector2.model.Step.ReadOnly {
    override val componentId: Component =
      zio.aws.inspector2.model.primitives.Component(impl.componentId())
    override val componentType: ComponentType =
      zio.aws.inspector2.model.primitives.ComponentType(impl.componentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Step
  ): zio.aws.inspector2.model.Step.ReadOnly = new Wrapper(impl)
}
