package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait RepositorySortBy {
  def unwrap: software.amazon.awssdk.services.inspector2.model.RepositorySortBy
}
object RepositorySortBy {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.RepositorySortBy
  ): zio.aws.inspector2.model.RepositorySortBy = value match {
    case software.amazon.awssdk.services.inspector2.model.RepositorySortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.RepositorySortBy.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.RepositorySortBy.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.RepositorySortBy.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.inspector2.model.RepositorySortBy.AFFECTED_IMAGES =>
      val r = AFFECTED_IMAGES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.RepositorySortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RepositorySortBy =
      software.amazon.awssdk.services.inspector2.model.RepositorySortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.inspector2.model.RepositorySortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RepositorySortBy =
      software.amazon.awssdk.services.inspector2.model.RepositorySortBy.CRITICAL
  }
  case object HIGH extends zio.aws.inspector2.model.RepositorySortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RepositorySortBy =
      software.amazon.awssdk.services.inspector2.model.RepositorySortBy.HIGH
  }
  case object ALL extends zio.aws.inspector2.model.RepositorySortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RepositorySortBy =
      software.amazon.awssdk.services.inspector2.model.RepositorySortBy.ALL
  }
  case object AFFECTED_IMAGES
      extends zio.aws.inspector2.model.RepositorySortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RepositorySortBy =
      software.amazon.awssdk.services.inspector2.model.RepositorySortBy.AFFECTED_IMAGES
  }
}
