package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.DateTimeTimestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExploitabilityDetails(
    lastKnownExploitAt: Optional[DateTimeTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ExploitabilityDetails = {
    import ExploitabilityDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ExploitabilityDetails
      .builder()
      .optionallyWith(
        lastKnownExploitAt.map(value =>
          DateTimeTimestamp.unwrap(value): Instant
        )
      )(_.lastKnownExploitAt)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ExploitabilityDetails.ReadOnly =
    zio.aws.inspector2.model.ExploitabilityDetails.wrap(buildAwsValue())
}
object ExploitabilityDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ExploitabilityDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ExploitabilityDetails =
      zio.aws.inspector2.model
        .ExploitabilityDetails(lastKnownExploitAt.map(value => value))
    def lastKnownExploitAt: Optional[DateTimeTimestamp]
    def getLastKnownExploitAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("lastKnownExploitAt", lastKnownExploitAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ExploitabilityDetails
  ) extends zio.aws.inspector2.model.ExploitabilityDetails.ReadOnly {
    override val lastKnownExploitAt: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastKnownExploitAt())
        .map(value =>
          zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ExploitabilityDetails
  ): zio.aws.inspector2.model.ExploitabilityDetails.ReadOnly = new Wrapper(impl)
}
