package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{AmiId, AccountId}
import scala.jdk.CollectionConverters._
final case class AmiAggregationResponse(
    accountId: Optional[AccountId] = Optional.Absent,
    affectedInstances: Optional[Long] = Optional.Absent,
    ami: AmiId,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AmiAggregationResponse = {
    import AmiAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AmiAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(affectedInstances.map(value => value: java.lang.Long))(
        _.affectedInstances
      )
      .ami(AmiId.unwrap(ami): java.lang.String)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.AmiAggregationResponse.wrap(buildAwsValue())
}
object AmiAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AmiAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AmiAggregationResponse =
      zio.aws.inspector2.model.AmiAggregationResponse(
        accountId.map(value => value),
        affectedInstances.map(value => value),
        ami,
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Optional[AccountId]
    def affectedInstances: Optional[Long]
    def ami: AmiId
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAffectedInstances: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("affectedInstances", affectedInstances)
    def getAmi: ZIO[Any, Nothing, AmiId] = ZIO.succeed(ami)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AmiAggregationResponse
  ) extends zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val affectedInstances: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.affectedInstances())
      .map(value => value: Long)
    override val ami: AmiId =
      zio.aws.inspector2.model.primitives.AmiId(impl.ami())
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AmiAggregationResponse
  ): zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly = new Wrapper(
    impl
  )
}
