package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{MapValue, MapKey}
import scala.jdk.CollectionConverters._
final case class LambdaFunctionMetadata(
    functionName: Optional[String] = Optional.Absent,
    functionTags: Optional[Map[MapKey, MapValue]] = Optional.Absent,
    layers: Optional[Iterable[String]] = Optional.Absent,
    runtime: Optional[zio.aws.inspector2.model.Runtime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.LambdaFunctionMetadata = {
    import LambdaFunctionMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.LambdaFunctionMetadata
      .builder()
      .optionallyWith(functionName.map(value => value: java.lang.String))(
        _.functionName
      )
      .optionallyWith(
        functionTags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.functionTags)
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(runtime.map(value => value.unwrap))(_.runtime)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.LambdaFunctionMetadata.ReadOnly =
    zio.aws.inspector2.model.LambdaFunctionMetadata.wrap(buildAwsValue())
}
object LambdaFunctionMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.LambdaFunctionMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.LambdaFunctionMetadata =
      zio.aws.inspector2.model.LambdaFunctionMetadata(
        functionName.map(value => value),
        functionTags.map(value => value),
        layers.map(value => value),
        runtime.map(value => value)
      )
    def functionName: Optional[String]
    def functionTags: Optional[Map[MapKey, MapValue]]
    def layers: Optional[List[String]]
    def runtime: Optional[zio.aws.inspector2.model.Runtime]
    def getFunctionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getFunctionTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("functionTags", functionTags)
    def getLayers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("layers", layers)
    def getRuntime: ZIO[Any, AwsError, zio.aws.inspector2.model.Runtime] =
      AwsError.unwrapOptionField("runtime", runtime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaFunctionMetadata
  ) extends zio.aws.inspector2.model.LambdaFunctionMetadata.ReadOnly {
    override val functionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.functionName())
      .map(value => value: String)
    override val functionTags: Optional[Map[MapKey, MapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.inspector2.model.primitives.MapKey(
                key
              ) -> zio.aws.inspector2.model.primitives.MapValue(value)
            })
            .toMap
        )
    override val layers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.layers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val runtime: Optional[zio.aws.inspector2.model.Runtime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtime())
        .map(value => zio.aws.inspector2.model.Runtime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaFunctionMetadata
  ): zio.aws.inspector2.model.LambdaFunctionMetadata.ReadOnly = new Wrapper(
    impl
  )
}
