package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait FreeTrialType {
  def unwrap: software.amazon.awssdk.services.inspector2.model.FreeTrialType
}
object FreeTrialType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.FreeTrialType
  ): zio.aws.inspector2.model.FreeTrialType = value match {
    case software.amazon.awssdk.services.inspector2.model.FreeTrialType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.FreeTrialType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.inspector2.model.FreeTrialType.ECR =>
      val r = ECR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.FreeTrialType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialType =
      software.amazon.awssdk.services.inspector2.model.FreeTrialType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.inspector2.model.FreeTrialType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialType =
      software.amazon.awssdk.services.inspector2.model.FreeTrialType.EC2
  }
  case object ECR extends zio.aws.inspector2.model.FreeTrialType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialType =
      software.amazon.awssdk.services.inspector2.model.FreeTrialType.ECR
  }
}
