package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{ReportId, ErrorMessage}
import scala.jdk.CollectionConverters._
final case class GetFindingsReportStatusResponse(
    destination: Optional[zio.aws.inspector2.model.Destination] =
      Optional.Absent,
    errorCode: Optional[zio.aws.inspector2.model.ReportingErrorCode] =
      Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    filterCriteria: Optional[zio.aws.inspector2.model.FilterCriteria] =
      Optional.Absent,
    reportId: Optional[ReportId] = Optional.Absent,
    status: Optional[zio.aws.inspector2.model.ExternalReportStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse = {
    import GetFindingsReportStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse
      .builder()
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.GetFindingsReportStatusResponse.ReadOnly =
    zio.aws.inspector2.model.GetFindingsReportStatusResponse
      .wrap(buildAwsValue())
}
object GetFindingsReportStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetFindingsReportStatusResponse =
      zio.aws.inspector2.model.GetFindingsReportStatusResponse(
        destination.map(value => value.asEditable),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        filterCriteria.map(value => value.asEditable),
        reportId.map(value => value),
        status.map(value => value)
      )
    def destination: Optional[zio.aws.inspector2.model.Destination.ReadOnly]
    def errorCode: Optional[zio.aws.inspector2.model.ReportingErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def filterCriteria
        : Optional[zio.aws.inspector2.model.FilterCriteria.ReadOnly]
    def reportId: Optional[ReportId]
    def status: Optional[zio.aws.inspector2.model.ExternalReportStatus]
    def getDestination
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Destination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ReportingErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ExternalReportStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse
  ) extends zio.aws.inspector2.model.GetFindingsReportStatusResponse.ReadOnly {
    override val destination
        : Optional[zio.aws.inspector2.model.Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.inspector2.model.Destination.wrap(value))
    override val errorCode
        : Optional[zio.aws.inspector2.model.ReportingErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.inspector2.model.ReportingErrorCode.wrap(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.inspector2.model.primitives.ErrorMessage(value))
    override val filterCriteria
        : Optional[zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value => zio.aws.inspector2.model.FilterCriteria.wrap(value))
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value => zio.aws.inspector2.model.primitives.ReportId(value))
    override val status
        : Optional[zio.aws.inspector2.model.ExternalReportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.inspector2.model.ExternalReportStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse
  ): zio.aws.inspector2.model.GetFindingsReportStatusResponse.ReadOnly =
    new Wrapper(impl)
}
