package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  IpV6Address,
  Platform,
  DateTimeTimestamp,
  IpV4Address,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AwsEc2InstanceDetails(
    iamInstanceProfileArn: Optional[NonEmptyString] = Optional.Absent,
    imageId: Optional[NonEmptyString] = Optional.Absent,
    ipV4Addresses: Optional[Iterable[IpV4Address]] = Optional.Absent,
    ipV6Addresses: Optional[Iterable[IpV6Address]] = Optional.Absent,
    keyName: Optional[NonEmptyString] = Optional.Absent,
    launchedAt: Optional[DateTimeTimestamp] = Optional.Absent,
    platform: Optional[Platform] = Optional.Absent,
    subnetId: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails = {
    import AwsEc2InstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails
      .builder()
      .optionallyWith(
        iamInstanceProfileArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.iamInstanceProfileArn)
      .optionallyWith(
        imageId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        ipV4Addresses.map(value =>
          value.map { item =>
            IpV4Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipV4Addresses)
      .optionallyWith(
        ipV6Addresses.map(value =>
          value.map { item =>
            IpV6Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipV6Addresses)
      .optionallyWith(
        keyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        launchedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.launchedAt)
      .optionallyWith(
        platform.map(value => Platform.unwrap(value): java.lang.String)
      )(_.platform)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly =
    zio.aws.inspector2.model.AwsEc2InstanceDetails.wrap(buildAwsValue())
}
object AwsEc2InstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AwsEc2InstanceDetails =
      zio.aws.inspector2.model.AwsEc2InstanceDetails(
        iamInstanceProfileArn.map(value => value),
        imageId.map(value => value),
        ipV4Addresses.map(value => value),
        ipV6Addresses.map(value => value),
        keyName.map(value => value),
        launchedAt.map(value => value),
        platform.map(value => value),
        subnetId.map(value => value),
        `type`.map(value => value),
        vpcId.map(value => value)
      )
    def iamInstanceProfileArn: Optional[NonEmptyString]
    def imageId: Optional[NonEmptyString]
    def ipV4Addresses: Optional[List[IpV4Address]]
    def ipV6Addresses: Optional[List[IpV6Address]]
    def keyName: Optional[NonEmptyString]
    def launchedAt: Optional[DateTimeTimestamp]
    def platform: Optional[Platform]
    def subnetId: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def getIamInstanceProfileArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamInstanceProfileArn", iamInstanceProfileArn)
    def getImageId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getIpV4Addresses: ZIO[Any, AwsError, List[IpV4Address]] =
      AwsError.unwrapOptionField("ipV4Addresses", ipV4Addresses)
    def getIpV6Addresses: ZIO[Any, AwsError, List[IpV6Address]] =
      AwsError.unwrapOptionField("ipV6Addresses", ipV6Addresses)
    def getKeyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getLaunchedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("launchedAt", launchedAt)
    def getPlatform: ZIO[Any, AwsError, Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails
  ) extends zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly {
    override val iamInstanceProfileArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfileArn())
        .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val imageId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val ipV4Addresses: Optional[List[IpV4Address]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipV4Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.IpV4Address(item)
          }.toList
        )
    override val ipV6Addresses: Optional[List[IpV6Address]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipV6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.IpV6Address(item)
          }.toList
        )
    override val keyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val launchedAt: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.launchedAt())
      .map(value =>
        zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
      )
    override val platform: Optional[Platform] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => zio.aws.inspector2.model.primitives.Platform(value))
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails
  ): zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly = new Wrapper(impl)
}
