package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait ResourceScanType {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ResourceScanType
}
object ResourceScanType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ResourceScanType
  ): zio.aws.inspector2.model.ResourceScanType = value match {
    case software.amazon.awssdk.services.inspector2.model.ResourceScanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ResourceScanType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.inspector2.model.ResourceScanType.ECR =>
      val r = ECR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ResourceScanType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceScanType =
      software.amazon.awssdk.services.inspector2.model.ResourceScanType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.inspector2.model.ResourceScanType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceScanType =
      software.amazon.awssdk.services.inspector2.model.ResourceScanType.EC2
  }
  case object ECR extends zio.aws.inspector2.model.ResourceScanType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceScanType =
      software.amazon.awssdk.services.inspector2.model.ResourceScanType.ECR
  }
}
