package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class DisableDelegatedAdminAccountResponse(
    delegatedAdminAccountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse = {
    import DisableDelegatedAdminAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse
      .builder()
      .delegatedAdminAccountId(
        AccountId.unwrap(delegatedAdminAccountId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.ReadOnly =
    zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse
      .wrap(buildAwsValue())
}
object DisableDelegatedAdminAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse =
      zio.aws.inspector2.model
        .DisableDelegatedAdminAccountResponse(delegatedAdminAccountId)
    def delegatedAdminAccountId: AccountId
    def getDelegatedAdminAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(delegatedAdminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse
  ) extends zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.ReadOnly {
    override val delegatedAdminAccountId: AccountId =
      zio.aws.inspector2.model.primitives
        .AccountId(impl.delegatedAdminAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse
  ): zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.ReadOnly =
    new Wrapper(impl)
}
